/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api.wsrr;

import filenet.vw.api.VWException;
import filenet.vw.api.VWSession;
import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSTemplateBase;
import filenet.ws.api.WSWSDLRefs;
import filenet.ws.api.wsrr.P8WSRRDocumentURI;
import filenet.ws.api.wsrr.WSWSRRRegistry;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.Document;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.WSDLDocument;
import filenet.ws.api.wsrr.serviceregistry_6_0.sdo.XSDDocument;
import java.io.File;
import java.io.FileOutputStream;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Vector;
import javax.wsdl.WSDLException;
import org.apache.axis.Constants;
import org.apache.axis.utils.XMLUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class WSWSRRDefinition
extends WSDefinition {
    protected static Logger logger = Logger.getLogger("filenet.ws.api.wsrr");
    protected static final String m_className = "WSWSRRDefinition";
    private WSWSRRRegistry m_wsrrRegistry = null;
    private String m_bsrURI = null;
    private Vector m_bsrURIs = null;
    private File m_localFileDir = null;
    private File m_localFileParentDir = null;
    private Vector m_localFiles = null;
    private Hashtable m_fileNames = new Hashtable();

    public void releaseReferences() {
        block2: {
            try {
                this.cleanup();
                super.releaseReferences();
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block2;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSWSRRDefinition(VWSession session, String wsdlURI) throws WSDLException, VWException, Exception {
        this.m_vwSession = session;
        WSWSDLRefs r = WSWSDLRefs.fromString(wsdlURI);
        wsdlURI = r.getWsdlURI();
        if (P8WSRRDocumentURI.isWSRRURI(wsdlURI)) {
            wsdlURI = this.getLocalFileURI(wsdlURI);
        }
        this.init(wsdlURI, r.getWsdlRef());
        this.cleanup();
    }

    public static WSDefinition getWSDefinition(VWSession session, String wsdlURI) throws VWException, Exception {
        return new WSWSRRDefinition(session, wsdlURI);
    }

    protected String getLocalFileURI(String wsrrURI) throws VWException, WSDLException, Exception {
        P8WSRRDocumentURI p8WSRRURI = new P8WSRRDocumentURI(wsrrURI);
        this.m_wsrrRegistry = p8WSRRURI.getWSWSRRRegistry(this.m_vwSession);
        this.m_bsrURI = p8WSRRURI.getBsrURI();
        this.m_localFiles = new Vector();
        String path = this.downloadAllAssociations(this.m_wsrrRegistry, this.m_bsrURI);
        if (path == null || path.trim().length() == 0) {
            throw new VWException("filenet.ws.api.wsrr.failedRetrievingWSRRDoc", "Failed to retrieve WSRR document - {0}", wsrrURI);
        }
        return new File(path).toURI().toASCIIString();
    }

    protected void cleanup() {
        if (this.m_localFiles != null) {
            Object obj = null;
            for (int i = 0; i < this.m_localFiles.size(); ++i) {
                obj = this.m_localFiles.get(i);
                if (obj == null || !(obj instanceof File)) continue;
                ((File)obj).delete();
            }
            this.m_localFiles.clear();
            this.m_localFiles = null;
            if (this.m_localFileDir != null) {
                this.m_localFileDir.delete();
            }
            this.m_localFileDir = null;
            if (this.m_localFileParentDir != null) {
                this.m_localFileParentDir.delete();
            }
            this.m_localFileParentDir = null;
            this.m_bsrURIs.clear();
            this.m_bsrURIs = null;
            this.m_bsrURI = null;
            this.m_wsrrRegistry = null;
        }
    }

    String downloadAllAssociations(WSWSRRRegistry registry, String bsrURI) throws VWException {
        String m_method = "downloadAllAssociationsbsrURI";
        String path = null;
        try {
            File dir;
            Document wsrrDocument = registry.retriveDocumentByBsrURI(bsrURI);
            if (wsrrDocument == null) {
                return path;
            }
            File fTempDir = File.createTempFile("wsrr", null);
            String sTempFile = fTempDir.getName();
            fTempDir.delete();
            String tempdir = System.getProperty("java.io.tmpdir");
            if (!tempdir.endsWith("/") && !tempdir.endsWith("\\")) {
                tempdir = tempdir + System.getProperty("file.separator");
            }
            if ((dir = new File(tempdir = tempdir + sTempFile)).exists()) {
                File[] files;
                if (dir.isDirectory() && (files = dir.listFiles()) != null) {
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                }
                dir.delete();
            }
            dir.mkdirs();
            dir.deleteOnExit();
            this.m_bsrURIs = new Vector();
            this.m_localFileDir = dir;
            path = this.saveImportsAndIncludes(registry, wsrrDocument, dir);
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            throw new VWException(ex);
        }
        return path;
    }

    String saveImportsAndIncludes(WSWSRRRegistry registry, Document wsrrDocument, File dir) throws VWException {
        String m_method = "saveImportsAndIncludes";
        String bsrURI = wsrrDocument.getBsrURI();
        if (this.m_bsrURIs.contains(bsrURI)) {
            return null;
        }
        this.m_bsrURIs.add(bsrURI);
        if (logger.isFinest()) {
            logger.fine(m_className, m_method, "bsrURI = " + wsrrDocument.getBsrURI() + " location" + wsrrDocument.getLocation() + " name = " + wsrrDocument.getName() + " namespace = " + wsrrDocument.getNamespace());
        }
        String path = null;
        if (wsrrDocument == null || dir == null) {
            return path;
        }
        try {
            int i;
            String[] importedWSDLbsrURIs = null;
            String[] importedXSDbsrURIs = null;
            String[] includedXSDbsrURIs = null;
            WSDLDocument[] importedWSDLs = null;
            XSDDocument[] importedXSDs = null;
            XSDDocument[] includedXSDs = null;
            if (wsrrDocument instanceof WSDLDocument) {
                importedWSDLbsrURIs = ((WSDLDocument)wsrrDocument).getImportedWSDLs();
                importedXSDbsrURIs = ((WSDLDocument)wsrrDocument).getImportedXSDs();
                includedXSDbsrURIs = ((WSDLDocument)wsrrDocument).getIncludedXSDs();
            } else if (wsrrDocument instanceof XSDDocument) {
                importedXSDbsrURIs = ((XSDDocument)wsrrDocument).getImportedXSDs();
                includedXSDbsrURIs = ((XSDDocument)wsrrDocument).getIncludedXSDs();
            }
            if (importedWSDLbsrURIs != null && importedWSDLbsrURIs.length > 0) {
                importedWSDLs = new WSDLDocument[importedWSDLbsrURIs.length];
                for (i = 0; i < importedWSDLs.length; ++i) {
                    importedWSDLs[i] = (WSDLDocument)registry.retriveDocumentByBsrURI(importedWSDLbsrURIs[i]);
                }
            }
            if (importedXSDbsrURIs != null && importedXSDbsrURIs.length > 0) {
                importedXSDs = new XSDDocument[importedXSDbsrURIs.length];
                for (i = 0; i < importedXSDbsrURIs.length; ++i) {
                    importedXSDs[i] = (XSDDocument)registry.retriveDocumentByBsrURI(importedXSDbsrURIs[i]);
                }
            }
            if (includedXSDbsrURIs != null && includedXSDbsrURIs.length > 0) {
                includedXSDs = new XSDDocument[includedXSDbsrURIs.length];
                for (i = 0; i < includedXSDbsrURIs.length; ++i) {
                    includedXSDs[i] = (XSDDocument)registry.retriveDocumentByBsrURI(includedXSDbsrURIs[i]);
                }
            }
            byte[] content = wsrrDocument.getContent();
            if (importedWSDLs != null && importedWSDLs.length > 0 || importedXSDs != null && importedXSDs.length > 0 || includedXSDs != null && includedXSDs.length > 0) {
                org.w3c.dom.Document doc = null;
                StringReader stringReader = new StringReader(new String(content));
                InputSource inputSource = new InputSource(stringReader);
                try {
                    try {
                        doc = XMLUtils.newDocument((InputSource)inputSource);
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                        VWException vwex = new VWException(ex);
                        throw vwex;
                    }
                    Object var20_21 = null;
                    stringReader.close();
                }
                catch (Throwable throwable) {
                    Object var20_22 = null;
                    stringReader.close();
                    throw throwable;
                }
                for (int loop = 0; loop < 2; ++loop) {
                    String target = null;
                    WSDLDocument[] WSDLs = null;
                    XSDDocument[] XSDs = null;
                    if (loop == 0) {
                        target = "import";
                        WSDLs = importedWSDLs;
                        XSDs = importedXSDs;
                    } else {
                        target = "include";
                        WSDLs = null;
                        XSDs = includedXSDs;
                    }
                    try {
                        Node node = null;
                        NodeList nodeList = doc.getElementsByTagNameNS("*", target);
                        block14: for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                            node = nodeList.item(i2);
                            if (node == null) continue;
                            Node namespaceNode = null;
                            String namespace = null;
                            NamedNodeMap attributes = node.getAttributes();
                            if (attributes != null && (namespaceNode = attributes.getNamedItem("namespace")) != null) {
                                namespace = namespaceNode.getNodeValue();
                            }
                            if (namespace != null && WSWSRRDefinition.isKnownNamespace(namespace)) continue;
                            Document[] wsrrDocs = null;
                            attributes = node.getAttributes();
                            Node fileNode = attributes.getNamedItem("schemaLocation");
                            if (fileNode != null) {
                                wsrrDocs = XSDs;
                            } else {
                                fileNode = attributes.getNamedItem("location");
                                if (fileNode != null) {
                                    wsrrDocs = WSDLs;
                                }
                            }
                            if (fileNode == null || wsrrDocs == null) continue;
                            String name = this.getNameFromLocation(fileNode.getNodeValue());
                            String aLocation = null;
                            String aNamespace = null;
                            for (int j = 0; j < wsrrDocs.length; ++j) {
                                aNamespace = wsrrDocs[j].getNamespace();
                                if (namespace != null && namespace.compareToIgnoreCase(aNamespace) != 0 || (aLocation = wsrrDocs[j].getLocation()).indexOf(name) == -1) continue;
                                this.saveImportsAndIncludes(registry, wsrrDocs[j], dir);
                                String fileName = this.generateFileNameFromLocation(aLocation);
                                fileNode.setNodeValue(fileName);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    catch (VWException ex) {
                        throw ex;
                    }
                    catch (Exception ex) {
                        logger.throwing(m_className, m_method, ex);
                        VWException vwex = new VWException(ex);
                        throw vwex;
                    }
                }
                String strContent = WSTemplateBase.docToString(doc);
                content = strContent.getBytes();
            }
            String name = this.generateFileNameFromLocation(wsrrDocument.getLocation());
            path = dir.getPath();
            if (!path.endsWith("/") && !path.endsWith("\\")) {
                path = path + System.getProperty("file.separator") + name;
            }
            File file = new File(path);
            file.deleteOnExit();
            FileOutputStream outStream = new FileOutputStream(file);
            outStream.write(content);
            outStream.flush();
            outStream.close();
            this.m_localFiles.add(file);
        }
        catch (VWException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.throwing(m_className, m_method, ex);
            VWException vwex = new VWException(ex);
            throw vwex;
        }
        return path;
    }

    String getNameFromLocation(String location) {
        int index2;
        int index = location.lastIndexOf("\\");
        if (index != -1) {
            index += 2;
        }
        if ((index2 = location.lastIndexOf("/")) != -1) {
            ++index2;
        }
        if (index2 > index) {
            index = index2;
        }
        if (index != -1) {
            location = location.substring(index);
        }
        if ((index = location.indexOf("?")) != -1) {
            location = location.substring(0, index);
        }
        return location;
    }

    String generateFileNameFromLocation(String location) {
        String fileName = (String)this.m_fileNames.get(location);
        if (fileName != null) {
            return fileName;
        }
        fileName = this.getNameFromLocation(location);
        int i = 0;
        while (this.m_fileNames.contains(fileName)) {
            fileName = fileName + Integer.toString(i);
            ++i;
        }
        this.m_fileNames.put(location, fileName);
        return fileName;
    }

    public static boolean isKnownNamespace(String namespace) {
        if (Constants.isSOAP_ENC((String)namespace)) {
            return true;
        }
        if (Constants.isSchemaXSD((String)namespace)) {
            return true;
        }
        if (Constants.isSchemaXSI((String)namespace)) {
            return true;
        }
        return namespace.equals("http://www.w3.org/XML/1998/namespace");
    }

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:04:06  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.8  $";
    }
}

